/******************************************************************************
 *
 * Copyright (c) 2003-2004 PalmSource, Inc. All rights reserved.
 *
 * File: float.h
 *
 * Release: Palm OS Developer Suite 5 SDK (68K) 4.0
 *
 * Description:
 *
 *
 *****************************************************************************/


#ifndef __PALMSOURCE_CC_HDR_FLOAT_H
#define __PALMSOURCE_CC_HDR_FLOAT_H


#define FLT_ROUNDS			 1  /* default is to nearest */
#define FLT_RADIX			 2
#define DECIMAL_DIG 		 17 /* supports both IEEE single and double */

#define FLT_MANT_DIG         24
#define FLT_DIG               6
#define FLT_MIN_EXP      (-125)
#define FLT_MIN_10_EXP    (-37)
#define FLT_MAX_EXP         128
#define FLT_MAX_10_EXP       38


#define DBL_MANT_DIG          53
#define DBL_DIG               15
#define DBL_MIN_EXP      (-1021)
#define DBL_MIN_10_EXP    (-308)
#define DBL_MAX_EXP         1024
#define DBL_MAX_10_EXP       308

#define LDBL_MANT_DIG          53
#define LDBL_DIG               15
#define LDBL_MIN_EXP      (-1021)
#define LDBL_MIN_10_EXP    (-308)
#define LDBL_MAX_EXP         1024
#define LDBL_MAX_10_EXP       308


#ifdef __PALMSOURCE_CC_HEX
/* C99 hex constants for IEEE single prec. */
#	define FLT_MAX       0x1.fffffeP127F
#	define FLT_EPSILON   0x1.000000P-23F
#	define FLT_MIN       0x1.000000P-126F
/* C99 hex constants for IEEE doubles */

#	define DBL_MAX       0x1.fffffffffffffP1023
#	define DBL_EPSILON   0x1.0000000000000P-52
#	define DBL_MIN       0x1.0000000000000P-1022

/* sizeof(double) == sizeof(long double) */

#	define LDBL_MAX       0x1.fffffffffffffP1023L
#	define LDBL_EPSILON   0x1.0000000000000P-52L
#	define LDBL_MIN       0x1.0000000000000P-1022L
#else	/* decimal constants */


#	define FLT_MAX 	      3.40282347e+38F
#	define FLT_EPSILON    1.19209290e-7F
#	define FLT_MIN 		  1.17549435e-38F

#	define DBL_MAX 		  1.79769313486231571e+308
#	define DBL_EPSILON    2.2204460492503131e-16
#	define DBL_MIN  	  2.22507385850720138e-308


#	define LDBL_MAX       1.79769313486231571e+308L
#	define LDBL_EPSILON   2.2204460492503131e-16
#	define LDBL_MIN        2.22507385850720138e-308L

#endif /* __PALMSOURCE_CC_HEX */

#endif /* __PALMSOURCE_CC_HDR_FLOAT_H */
